//
//  YHRiskWarningCell.swift
//  galaxy
//
//  Created by edy on 2024/8/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHRiskWarningCell: UITableViewCell {

    static let cellReuseIdentifier = "YHRiskWarningCell"

    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var bgImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "risk_warn_bg"))
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var iconImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "risk_warn_icon"))
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 13)
        label.text = "风险预警："
        label.textColor = UIColor.init(hex: 0xFF8000)
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 12)
        let a: ASAttributedString = .init("如若在等待获批期间，", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        let b: ASAttributedString = .init("您的家庭信息与之前递交港府的申请资料不一致，请务必如实告知", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.init(hex: 0xFF8000)))
        let c: ASAttributedString = .init("，因为这会导致后续赴港激活签证所带的证件不一样！", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        label.attributed.text = a+b+c
        return label
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(bgImgView)
        whiteContentView.addSubview(iconImgView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(detailLabel)
        
        whiteContentView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(16)
            make.right.equalTo(-16)
        }
        
        bgImgView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        iconImgView.snp.makeConstraints { make in
            make.width.height.equalTo(14)
            make.top.equalTo(18)
            make.left.equalTo(16)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(iconImgView.snp.right).offset(8)
            make.height.equalTo(18)
            make.centerY.equalTo(iconImgView)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(titleLabel.snp.bottom).offset(8)
            make.bottom.equalTo(-16)
        }
    }
}
